/*
 * TagTreeContextMenu.h
 *
 *  Created on: 03.05.2010
 *      Author: stefan.detter
 */

#ifndef TAGTREECONTEXTMENU_H_
#define TAGTREECONTEXTMENU_H_

#include <QObject>
#include <QModelIndex>

#include <def.h>

class QWidget;
class QTreeView;
class QMenu;
class QAction;

class TagTreeModel;
class TagTreeProxy;

class TagTreeContextMenu : public QObject
{
	Q_OBJECT
public:
	TagTreeContextMenu(QTreeView* treeView, TagTreeModel* tagTreeModel, TagTreeProxy* tagTreeProxy, QWidget* window, QObject* parent = 0);
	virtual ~TagTreeContextMenu();

public slots:
	void showPopup(const QPoint & iPoint);
	void settingsRequested();
    void removeReaderRequested();

	void copyToClipboardRequested();

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

	void addReaderDialogRequested();
	void removeReaderRequested(QString readerId);

private:
    QTreeView* 			m_treeView;
    TagTreeModel* 		m_tagTreeModel;
    TagTreeProxy* 		m_tagTreeProxy;
    QWidget* 			m_window;

    QMenu* 				m_context;
    QAction* 			m_context_Settings;
    QAction* 			m_context_AppSettings;
    QAction*			m_context_AddReader;
    QAction*			m_context_RemoveReader;
    QAction*			m_context_ClearTags;

    QAction*			m_context_CopyTagId;

    QAction* 			m_context_Pipe;
    QAction* 			m_context_Engineering;

    QModelIndex			m_contextIndex;
};

#endif /* TAGTREECONTEXTMENU_H_ */
